pico-8 cartridge // http://www.pico-8.com
version 32
__lua__
x=40
y=8
dy=8
sprite=134
show = false
selection = 1

function draw1()
	fade()
	cls()
	map(0,0)
	
	print("level pack 1",42,53,8)
	print("level pack 2",42,109,8)
	spr(sprite,x,y,6,6)
	drawparts()
	
	if dget(0) == 1 then
		spr(128,40,8,6,6)
	end

	if dget(1) == 1 then
		spr(128,40,64,6,6)
	end
	
	if show then
		if btn(⬆️)then print("⬆️",30,10) end
		if btn(⬇️)then print("⬇️",40,10) end
		if btn(❎)then print("❎",50,10) end
		if btn(🅾️)then print("🅾️",60,10) end
		print(selection,20,10)
	end
end

function update1()
updateparts()
	if btnp(❎) and selection == 1 and dy == y then spawnpillpuft(x+24,y+24,2) fadedir = 1 end
	if btnp(❎) and selection == 2 and dy == y then spawnpillpuft(x+24,y+24,2) fadedir=1 end
	if btnp(⬇️) and y < 60 and dy == y then
		dy+=56
		selection += 1
	end
	if btnp(⬆️) and y > 50 and dy == y then
		dy -= 56
		selection -= 1
	end
	
	if y > dy then
		y -= 4
	elseif y < dy then
		y+=4
	end
end

function reset_achievements()
	dset(0,0)
	dset(1,0)
end
menuitem(1,"reset awards", reset_achievements)
-->8
function _init()
	part={}
	fadedir = -2
	fadepos = 20
	cartdata("possiblyaxolotl_beancompletion")
	_draw = draw1
	_update60 = update1
end
-->8
-- fade
function fade()
--add vars fadedir and fadepos
--constantly run fade
--fadedir -1 fade in 1 fade out
local fade,c,p={[0]=0,17,18,19,20,16,22,6,24,25,9,27,28,29,29,31,0,0,16,17,16,16,5,0,2,4,0,3,1,18,2,4}
  pal()
  for i=0,fadepos do
    if i%2==1 then
      for j=0,15 do
        c=peek(24336+j)
        if (c>=128) c-=112
        p=fade[c]
        if (p>=16) p+=112
        pal(j,p,1)
      end
    end
  end
  fadepos+=fadedir
  if (fadepos<0) fadedir=0 fadepos=0
  if (fadepos>21) fadedir=-2 fadepos=21
		if fadepos >= 21 and selection == 1 then load("bean1.p8", "back to games") end
		if fadepos >= 21 and selection == 2 then load("bean2.p8", "back to games") end
		if fadepos >= 21 and selection == 3 then load("menu.p8") end
end 
-->8
function addpart(_x,_y,_dx,_dy,_type,_maxage,_col,_s)
 local _p = {}
 _p.x=_x
 _p.y=_y
 _p.dx=_dx
 _p.dy=_dy
 _p.tpe=_type 
 _p.mage=_maxage
 _p.age=0
 _p.col=0
 _p.colarr=_col
 _p.rot=0
 _p.rottimer=0
 _p.s=_s
 _p.os=_s
 
 add(part,_p)
end
 
-- spawn a small puft
function spawnpuft(_x,_y)
 for i= 0,5 do
  local _ang = rnd()
  local _dx = sin(_ang)*1
  local _dy = cos(_ang)*1
  addpart(_x,_y,_dx,_dy,2,15+rnd(15),{7,6,5},1+rnd(2))
 end
end
 
-- spawn a puft in the color of a pill
function spawnpillpuft(_x,_y,_p)
 for i= 0,20 do
  local _ang = rnd()
  local _dx = sin(_ang)*(1+rnd(2))
  local _dy = cos(_ang)*(1+rnd(2))
  local _mycol
  
  if _p == 1 then
   -- slowdown -- orange
   _mycol={9,9,4,4,0}
  elseif _p == 2 then
   -- life -- white
   _mycol={7,7,6,5,0}
  elseif _p == 3 then
   -- catch -- green
   _mycol={11,11,3,3,0}
  elseif _p == 4 then
   -- expand -- blue
   _mycol={12,12,5,5,0}
  elseif _p == 5 then
   -- reduce -- black
   _mycol={0,0,5,5,6}
  elseif _p == 6 then
   -- megaball -- pink
   _mycol={14,14,13,2,0}
  else
   -- multiball -- red
   _mycol={8,8,4,2,0}
  end  
  addpart(_x,_y,_dx,_dy,2,20+rnd(15),_mycol,1+rnd(4))
 end
end
 
-- spawn death particles
function spawndeath(_x,_y)
 for i= 0,30 do
  local _ang = rnd()
  local _dx = sin(_ang)*(2+rnd(4))
  local _dy = cos(_ang)*(2+rnd(4))
  local _mycol
  
  _mycol={10,10,9,4,0}
  addpart(_x,_y,_dx,_dy,2,80+rnd(15),_mycol,3+rnd(6))
 end
end
 
-- spawn death particles
function spawnexplosion(_x,_y)
 --first smoke
 sfx(14)
 for i= 0,20 do
  local _ang = rnd()
  local _dx = sin(_ang)*(rnd(4))
  local _dy = cos(_ang)*(rnd(4))
  local _mycol
  _mycol={0,0,5,5,6}
  addpart(_x,_y,_dx,_dy,2,80+rnd(15),_mycol,3+rnd(6))
 end
 --fireball
 for i= 0,30 do
  local _ang = rnd()
  local _dx = sin(_ang)*(1+rnd(4))
  local _dy = cos(_ang)*(1+rnd(4))
  local _mycol
  _mycol={7,10,9,8,5}
  addpart(_x,_y,_dx,_dy,2,30+rnd(15),_mycol,2+rnd(4))
 end
 
end
 
-- spawn a trail particle
function spawntrail(_x,_y)
 if rnd()<0.5 then
  local _ang = rnd()
  local _ox = sin(_ang)*4*0.3
  local _oy = cos(_ang)*4*0.3
 
  addpart(_x+_ox,_y+_oy,0,0,0,15+rnd(15),{5,6},0)
 end
end
 
-- spawn a megatrail particle
function spawnmtrail(_x,_y)
 if rnd() then
  local _ang = rnd()
  local _ox = sin(_ang)*2
  local _oy = cos(_ang)*2
 
  addpart(_x+_ox,_y+_oy,0,0,2,20+rnd(15),{14,8,2},1+rnd(1))
 end
end

function updateparts()
 local _p
 for i=#part,1,-1 do
  _p=part[i]
  _p.age+=1
  if _p.age>_p.mage then
   del(part,part[i]) 
  else
   -- change colors
   if #_p.colarr==1 then
    _p.col = _p.colarr[1]
   else
    local _ci=_p.age/_p.mage
    _ci=1+flr(_ci*#_p.colarr)
    _p.col = _p.colarr[_ci]
   end
   
   --appy gravity
   if _p.tpe == 1 or _p.tpe == 3 then
    _p.dy+=0.05
   end
   
   --rotate
   if _p.tpe == 3 then
    _p.rottimer+=1
    if _p.rottimer>5 then
     _p.rot+=1
     if _p.rot>=4 then
      _p.rot=0
     end
    end
   end
   
   --shrink
   if _p.tpe == 2 then
    local _ci=1-(_p.age/_p.mage)
    _p.s=_ci*_p.os
   end
   
   --friction
   if _p.tpe == 2 then
             _p.dx=_p.dx/1.2
             _p.dy=_p.dy/1.2
   end
   
   --move particle
   _p.x+=_p.dx
   _p.y+=_p.dy
  end
 end  
end
 
-- big particle drawer
function drawparts()
 for i=1,#part do
  _p=part[i]
  -- pixel particle
  if _p.tpe == 0 or _p.tpe == 1 then
   pset(_p.x,_p.y,_p.col)
  elseif _p.tpe == 2 then
   circfill(_p.x,_p.y,_p.s,_p.col)
  elseif _p.tpe == 3 then
   local _fx,_fy
   if _p.rot==2 then
    _fx=false
    _fy=true
   elseif _p.rot==3 then
    _fx=true
    _fy=true
   elseif _p.rot==4 then
    _fx=true
    _fy=false
   else
    _fx=false
    _fy=false
   end
   
   spr(_p.col,_p.x,_p.y,1,1,_fx,_fy)
  end
 end  
end
__gfx__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00700700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00077000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00077000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00700700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
77777000000000000000000000000000777770000000000000000000000000003333333b0333333b333333b03333333b0333333b333333b00000000000000000
70000700000000000000000000000000700007000000000000000000000000003333333b3333333b3333333b3333333b3333333b3333333b0000000000000000
700007000007777000000000000000007000070000077770000000000000000033b0000033b0000033b0033b33b0000033b0000033b0033b0000000000000000
77777777007000070077777007777000777777770070000700777770077770003333333b33b000003333333b3333333b33b000003333333b0000000000000000
70000000707000070700007070000700700000007070000707000070700007003333333b33b00000333333b03333333b33b00000333333b00000000000000000
70000000707777700700007070000700700000007077777007000070700007000000033b33b0000033b033b00000033b33b0000033b033b00000000000000000
70000000707000000700077070000700700000007070000007000770700007003333333b3333333b33b0333b3333333b3333333b33b0333b0000000000000000
77777777000777770077707070000700777777770007777700777070700007003333333b0333333b33b0033b3333333b0333333b33b0033b0000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0222e0022e02e02e022e0022e222e000222e0022e02e02e022e0022e222e00000011110000111100011111100111111001001010001111000000000000000000
02e02e2222e2e02e2222e222e2e000002e02e2222e2e02e2222e222e2e0000000100001001000010010000000001000001001010010000100000000000000000
02e02e2e02e2e02e2e02e2e00222e0002e02e2e02e2e02e2e02e2e00222e02e00100001001000010011100000001000001001010010000100000000000000000
0222e02e02e2e02e2e02e2e002e00000222e02e02e2e02e2e02e2e002e00222e0100001001000010010000000001000001001010010000100000000000000000
02e02e2222e2222e2e02e222e2e000002e02e2222e2222e2e02e222e2e0002e00100001001000010010000000001000001001010010000100000000000000000
02222e022e0022e02e02e022e222e0002222e022e0022e02e02e022e222e00000011110001000010011111100001000000110100001111000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000333333333333333300000000000000009999999999999999033333b033b0000033b00000033333b033b0000033b000000000000000000000
00000000000000003333333333333333000000000000000099999999999999993333333b33b0000033b000003333333b33b0000033b000000000000000000000
0000222222000000b3b3b33bb3b3b33b0000222222000000a9a9a99aa9a9a99a333b333b33b0000033b00000333b333b33b0000033b000000000000000000000
0002878878200000439b7bb9439b7bb9000287887820000039ba7aab39ba7aab33b0033b33b0000033b0000033b0033b33b0000033b000000000000000000000
00028888882000004b9974994b99749900028888882000003abb73bb3abb73bb33b0033b33b0000033b0000033b0033b33b0000033b000000000000000000000
00028888882000004499949944999499000288888820000033bbb3bb33bbb3bb333b333b33b0000033b00000333b333b33b0000033b000000000000000000000
0000222222000000444444494444444900002222220000003333333b3333333b3333333b3333333b3333333b3333333b3333333b3333333b0000000000000000
0000000000000000444444444444444400000000000000003333333333333333033333b03333333b3333333b033333b03333333b3333333b0000000000000000
0000707707000000499997774999977700007077070000003bbbb7773bbbb7770000000000000000000000000000000000000000000000000000000000000000
00007077070000004499999744999997000070770700000033bbbbb733bbbbb70000000000000000000000000000000000000000000000000000000000000000
000070700700000044444497444444970000707007000000333333b7333333b70000000000000000000000000000000000000000000000000000000000000000
00707070070700004497749944977499007070700707000033b773bb33b773bb0000000000000000000000000000000000000000000000000000000000000000
00070077007000004499749944997499000700770070000033bb73bb33bb73bb0000000000000000000000000000000000000000000000000000000000000000
33333333333333334499949944999499999999999999999933bbb3bb33bbb3bb0000000000000000000000000000000000000000000000000000000000000000
3333333333333333444444494444444999999999999999993333333b3333333b0000000000000000000000000000000000000000000000000000000000000000
b3b3b33bb3b3b33b4444444444444444a9a9a99aa9a9a99a33333333333333330000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000006666666666666666666666666666666666666666000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000006000000000000000000000000000000000000006000000000000000000000000000000000000
00000099999999999999999999999999999999999900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009a00000000000000000000000000000000a900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
0000009aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
00000099999999999999999999999999999999999900000000006000000000000000000000000000000000000006000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000006000000000000000000000000000000000000006000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000006666666666666666666666666666666666666666000000000000000000000000000000000000
__gff__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000030300000000000000000000000000000303000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000030300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000004041424300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000005051525300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000006061626300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000007071727300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000004445464700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000005455565700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000006465666700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000007475767700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
